<?php

namespace Drupal\salesforce_push_queue_ui\Plugin\views\field;

use Drupal\views\ResultRow;

/**
 * A handler to display expiration timestamps with status indicators.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("salesforce_push_queue_expire")
 */
class ExpireField extends TimestampField {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $value = $this->getValue($values);

    if (empty($value) || $value == 0) {
      return [
        '#markup' => '<span class="expire-status expire-none">' . $this->t('Not set') . '</span>',
      ];
    }

    $current_time = \Drupal::time()->getRequestTime();
    $is_expired = $value < $current_time;

    // Get the formatted date from parent.
    $formatted_date = parent::render($values);

    if ($is_expired) {
      return [
        '#markup' => '<span class="expire-status expire-expired" title="' . $this->t('This item has expired') . '">' .
        '🔴 ' . $formatted_date . '</span>',
      ];
    }
    else {
      return [
        '#markup' => '<span class="expire-status expire-active" title="' . $this->t('This item is active') . '">' .
        '🟢 ' . $formatted_date . '</span>',
      ];
    }
  }

}
