<?php

namespace Drupal\salesforce_push_queue_ui\Plugin\views\filter;

use Drupal\Core\Database\Connection;
use Drupal\views\Plugin\views\filter\InOperator;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Filter by mapping name using a select list.
 *
 * @ingroup views_filter_handlers
 *
 * @ViewsFilter("salesforce_push_queue_mapping_name")
 */
class MappingNameFilter extends InOperator {

  /**
   * The database connection.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected $database;

  /**
   * Constructs a new MappingNameFilter object.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\Core\Database\Connection $database
   *   The database connection.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, Connection $database) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->database = $database;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('database')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getValueOptions() {
    if (isset($this->valueOptions)) {
      return $this->valueOptions;
    }

    $this->valueOptions = [];

    // Get unique mapping names from the queue table.
    $query = $this->database->select('salesforce_push_queue', 'spq')
      ->fields('spq', ['name'])
      ->distinct()
      ->orderBy('name');

    $result = $query->execute();

    foreach ($result as $row) {
      $this->valueOptions[$row->name] = $row->name;
    }

    return $this->valueOptions;
  }

}
