<?php

namespace Drupal\sanitize_placeholder_extra\Strategy;

use Drupal\sanitize_placeholder\Strategy\StrategyInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;

/**
 * Generates geographic coordinates in "lat,long" format.
 *
 * Latitude ∈ [-90, 90], Longitude ∈ [-180, 180] with up to 6 decimals.
 */
final class CoordsStrategy implements StrategyInterface {

  /**
   * Get strategy id.
   */
  public function id(): string {
    return 'coords';
  }

  /**
   * Get strategy label.
   */
  public function label(): string {
    return 'Coordinates (lat,long)';
  }

  /**
   * {@inheritdoc}
   *
   * Produces deterministic-looking but random coordinates.
   *
   * @throws \Exception
   */
  public function generate(EntityInterface $entity, FieldDefinitionInterface $field): string {
    $lat = random_int(-90000000, 90000000) / 1_000_000;
    $lng = random_int(-180000000, 180000000) / 1_000_000;
    // Normalize to 6 decimal places max, without locale interference.
    $lat = number_format($lat, 6, '.', '');
    $lng = number_format($lng, 6, '.', '');
    return $lat . ',' . $lng;
  }

}
