<?php

namespace Drupal\sanitize_placeholder_extra\Strategy;

use Drupal\sanitize_placeholder\Strategy\StrategyInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;

/**
 * Generates a Portuguese-style license plate (AA-00-AA).
 *
 * This does not attempt to validate historical formats; it just follows the
 * modern-looking pattern of two letters, two digits, two letters.
 */
final class LicensePlatePtStrategy implements StrategyInterface {

  /**
   * {@inheritdoc}
   */
  public function id(): string {
    return 'license_plate_pt';
  }

  /**
   * {@inheritdoc}
   */
  public function label(): string {
    return 'Portuguese license plate (AA-00-AA)';
  }

  /**
   * {@inheritdoc}
   *
   * @throws \Exception
   */
  public function generate(EntityInterface $entity, FieldDefinitionInterface $field): string {
    $letters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $part1 = $letters[random_int(0, 25)] . $letters[random_int(0, 25)];
    $part2 = str_pad((string) random_int(0, 99), 2, '0', STR_PAD_LEFT);
    $part3 = $letters[random_int(0, 25)] . $letters[random_int(0, 25)];
    return $part1 . '-' . $part2 . '-' . $part3;
  }

}
