<?php

declare(strict_types=1);

namespace Drupal\sanitize_placeholder\Strategy;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\sanitize_placeholder\Service\ThematicFaker;

/**
 * Strategy that generates a first name.
 */
final class FirstNameStrategy implements StrategyInterface {

  /**
   * Constructs a FirstNameStrategy.
   *
   * @param \Drupal\sanitize_placeholder\Service\ThematicFaker $faker
   *   The faker wrapper service.
   */
  public function __construct(
    private readonly ThematicFaker $faker,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function id(): string {
    return 'first_name';
  }

  /**
   * {@inheritdoc}
   */
  public function label(): string {
    return 'First name';
  }

  /**
   * {@inheritdoc}
   *
   * @throws \Exception
   */
  public function generate(EntityInterface $entity, FieldDefinitionInterface $field_definition): string {
    return $this->faker->firstName();
  }

}
