<?php

declare(strict_types=1);

namespace Drupal\sanitize_placeholder\Strategy;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\sanitize_placeholder\Service\ThematicFaker;

/**
 * Strategy that generates a last name.
 */
final class LastNameStrategy implements StrategyInterface {

  /**
   * Constructs a LastNameStrategy.
   *
   * @param \Drupal\sanitize_placeholder\Service\ThematicFaker $faker
   *   The faker wrapper service.
   */
  public function __construct(
    private readonly ThematicFaker $faker,
  ) {}

  /**
   * Get strategy id.
   */
  public function id(): string {
    return 'last_name';
  }

  /**
   * Get strategy label.
   */
  public function label(): string {
    return 'Last name';
  }

  /**
   * {@inheritdoc}
   *
   * @throws \Exception
   */
  public function generate(EntityInterface $entity, FieldDefinitionInterface $field_definition): string {
    return $this->faker->lastName();
  }

}
