<?php

declare(strict_types=1);

namespace Drupal\sanitize_placeholder\Strategy;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;

/**
 * Defines the contract for a placeholder replacement strategy.
 */
interface StrategyInterface {

  /**
   * Generate a replacement value for a field on a specific entity.
   *
   * Implementations must be side-effect free and fast.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity being processed.
   * @param \Drupal\Core\Field\FieldDefinitionInterface $field_definition
   *   The field definition for the field to be replaced.
   *
   * @return string
   *   The generated replacement value.
   */
  public function generate(EntityInterface $entity, FieldDefinitionInterface $field_definition): string;

}
