<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Fixer;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Fixer;
use Drupal\scanner_fixer_api\Fixer\FixerInterface;

/**
 * A fixer that says it can fix an item, then does so successfully.
 */
#[Fixer(
  id: "capable_successful_fixer",
  title: new TranslatableMarkup("Test: capable, successful fixer"),
)]
class CapableSuccessfulFixer implements FixerInterface {

  /**
   * {@inheritdoc}
   */
  public function canFix(mixed $item): bool {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function performFix(mixed $item): bool {
    return TRUE;
  }

}
