<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Fixer;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Fixer;
use Drupal\scanner_fixer_api\Fixer\FixerInterface;

/**
 * A fixer that throws an exception when trying to fix the item.
 */
#[Fixer(
  id: "exception_fixer",
  title: new TranslatableMarkup("Test: exception fixer"),
)]
class ExceptionFixer implements FixerInterface {

  /**
   * {@inheritdoc}
   */
  public function canFix(mixed $item): bool {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function performFix(mixed $item): bool {
    throw new \Exception('Message.', 314);
  }

}
