<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Scanner;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Scanner;
use Drupal\scanner_fixer_api\Scanner\ScannerInterface;

/**
 * A scanner that finds one item to fix.
 */
#[Scanner(
  id: "one_items_scanner",
  title: new TranslatableMarkup("Test: One item scanner"),
)]
class OneItemsScanner implements ScannerInterface {

  /**
   * {@inheritdoc}
   */
  public function findProblemIds(): array {
    $id = \mt_rand();
    return [$id => $id];
  }

}
