<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Solution;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Solution;
use Drupal\scanner_fixer_api\Solution\SolutionBase;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Scanner\OneItemsScanner;

/**
 * A test scanner-fixer whose scanner finds one item to fix.
 */
#[Solution(
  id: "one_items_scanner",
  title: new TranslatableMarkup("Test solution: One item scanner"),
  description: new TranslatableMarkup("A scanner-fixer whose scanner finds one item to fix."),
  scanners: [OneItemsScanner::class],
  fixers: [],
)]
class OneItemsScannerSolution extends SolutionBase {}
