<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Solution;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Solution;
use Drupal\scanner_fixer_api\Solution\SolutionBase;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Fixer\CapableSuccessfulFixer;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Scanner\FiveItemsScanner;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Scanner\OneItemsScanner;

/**
 * A solution that uses more than one scanner to get its job done.
 */
#[Solution(
  id: "two_scanners_solution",
  title: new TranslatableMarkup("Test solution: Two scanners"),
  description: new TranslatableMarkup("A scanner-fixer that uses two scanners."),
  scanners: [OneItemsScanner::class, FiveItemsScanner::class],
  fixers: [CapableSuccessfulFixer::class],
)]
class TwoScannersSolution extends SolutionBase {}
