<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Solution;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Solution;
use Drupal\scanner_fixer_api\Solution\SolutionBase;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Fixer\CapableFailureFixer;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Scanner\OneItemsScanner;

/**
 * A test scanner-fixer that finds 1 item to fix, but fails to follow through.
 */
#[Solution(
  id: "capable_failure_fixer",
  title: new TranslatableMarkup("Test solution: Capable, failure fixer"),
  description: new TranslatableMarkup("A scanner-fixer whose scanner finds one item and whose fixer says it can fix an item, but fails to follow through with that."),
  scanners: [OneItemsScanner::class],
  fixers: [CapableFailureFixer::class],
)]
class CapableFailureFixerSolution extends SolutionBase {}
