<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Solution;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Solution;
use Drupal\scanner_fixer_api\Solution\SolutionBase;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Fixer\IncapableFixer;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Scanner\OneItemsScanner;

/**
 * A test scanner-fixer that finds 1 item but cannot fix it.
 */
#[Solution(
  id: "incapable_fixer",
  title: new TranslatableMarkup("Test solution: Incapable fixer"),
  description: new TranslatableMarkup("A scanner-fixer whose scanner finds one item and whose fixer says it cannot fix the item."),
  scanners: [OneItemsScanner::class],
  fixers: [IncapableFixer::class],
)]
class IncapableFixerSolution extends SolutionBase {}
