<?php

declare(strict_types=1);

namespace Drupal\Tests\scanner_fixer_api\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests the Solution overview page when there are no solutions.
 *
 * Note this test only installs the base scanner_fixer_api module, which doesn't
 * define any of its own solutions. Contrast this with the SolutionOverview test
 * which installs the scanner_fixer_api_test test module, which defines a
 * handful of solutions.
 *
 * @group scanner_fixer_api
 */
class SolutionOverviewEmptyTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['scanner_fixer_api'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * The Solution overview page should show the empty text when 0 solutions.
   */
  public function testShowsEmptyTextWhenNoSolutions(): void {
    // Setup: Create a user with the overview page permission and log in.
    $this->drupalLogin($this->createUser([
      'use scanner-fixer solution overview page',
    ]));

    // SUT: Load the Solution overview page.
    $this->drupalGet('/admin/content/scanner_fixer_api');

    // Setup: We should get a success error code and see the title of the page.
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains('No scanner-fixer solutions have been registered yet.');
  }

}
