# Scanner-Fixer API

A framework for scanning for issues and then fixing them.

A _Scanner_ is a way to find things to fix, as the first step in a Solution.
Scanners aren't designed to be run on their own. A Scanner produces an array of
item IDs (e.g.: node IDs, taxonomy IDs, UUIDs, etc.) that will be passed to
Fixers to work on.

A _Fixer_ is a way to act upon the things found by a Scanner, as the second step
in a Solution. Fixers aren't designed to be run on their own either. A Fixer
evaluates an item ID to see if it can fix it (i.e.: if it can act upon it). A
Fixer can also try to perform a fix on an item ID.

A _Solution_ is a way to group Scanners and Fixers. That is to say, a Solution
allows the output from one or more Scanners to be combined together into a
larger array of item IDs. The resulting array is passed to one or more Fixers to
act upon those IDs.


## Requirements

This module requires no modules outside of Drupal core.


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

The Scanner-Fixer API is a developer module, which is to say that all
functionality in the module is defined by writing code, and the module has no
configuration of its own.

See the _Scanner-Fixer API example_ sub-module
(`modules/scanner_fixer_api_example`) for an example, and documentation.

The module displays a list of Solutions at `/admin/content/scanner_fixer_api` in
order to make it easier to run Solutions from Drupal's web UI. A user needs a
role with the _Use the Scanner-fixer solution-overview page_ permission
(`use scanner-fixer solution overview page`) in order to see the list of
Solutions.

The module generates a permission for each Solution; and a user must have that
permission in order to run the Solution from the UI.

The Scanner-Fixer API module also defines Drush commands for listing and running
solutions:

* To list solutions, run `drush scanner-fixer:list-solutions`
* To run a particular solution, run `drush scanner-fixer:run-solution solution_id`


## Troubleshooting

Note that *all* of the Scanners and Fixers that make up a Solution *must* agree
on an item ID format. That is to say, the item IDs produced by the Scanner(s)
and acted upon by the Fixer(s) must either all refer to the same thing (e.g.:
all be node IDs), or must be unambiguous in some way (e.g.: a string like
'entity_type/NID', or a UUID). Put another way, creating a Solution that
combines a Scanner that returns Node IDs, with a Fixer that loads and acts on
Taxonomy Term IDs will produce undesirable results!

While developing a Scanner, it may be helpful to run a Scanner on its own, in
order to see the Scanner's output. The module provides a Drush command to do
this: `drush scanner-fixer:run-scanner scanner_id` (where `scanner_id` is the
Scanner's plugin ID).

While developing a Fixer, it may be helpful to run a Fixer on a single item ID,
in order to see how the Fixer acts on that item. The module provides a Drush
command to do this: `drush scanner-fixer:run-fixer fixer_id item_id` (where
`fixer_id` is the Fixer's plugin ID, and `item_id` is the item ID to test.

While developing a Solution, it can be helpful to see which Scanners and Fixers
are available. The module provides two Drush commands to do so:
`drush scanner-fixer:list-scanners` lists available Scanners, and
`drush scanner-fixer:list-fixers` lists available Fixers.

If you don't see a Scanner that you expected:

1. Ensure the module that contains the Scanner is enabled,
2. Ensure the class that defines the Scanner is:
    1. in
        `path_to_your_module/src/Plugin/ScannerFixer/Scanner/YourScannerClass.php`,
    2. the Scanner's `namespace` is
        `Drupal\scanner_fixer_api_example\Plugin\ScannerFixer\Scanner`,
    3. the class name matches the filename,
    4. the class is annotated with
        `\Drupal\scanner_fixer_api\Annotation\Scanner`, and defines an `id` and
        `title`, and,
    5. the class implements `\Drupal\scanner_fixer_api\Scanner\ScannerInterface`.
3. Ensure that you have flushed caches.

If you don't see a Fixer that you expected:

1. Ensure the module that contains the Fixer is enabled,
2. Ensure the class that defines the Fixer is:
    1. in
        `path_to_your_module/src/Plugin/ScannerFixer/Scanner/YourScannerClass.php`,
    2. the Scanner's `namespace` is
        `Drupal\scanner_fixer_api_example\Plugin\ScannerFixer\Scanner`,
    3. the class name matches the filename,
    4. the class is annotated with
        `\Drupal\scanner_fixer_api\Annotation\Scanner`, and defines an `id` and
        `title`, and,
    5. the class implements `\Drupal\scanner_fixer_api\Scanner\ScannerInterface`.
3. Ensure that you have flushed caches.
