<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Solution;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Solution;
use Drupal\scanner_fixer_api\Solution\SolutionBase;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Scanner\ZeroItemsScanner;

/**
 * A test scanner-fixer whose scanner finds nothing to fix.
 */
#[Solution(
  id: "zero_items_scanner",
  title: new TranslatableMarkup("Test solution: Zero items scanner"),
  description: new TranslatableMarkup("A scanner-fixer whose scanner finds nothing to fix."),
  scanners: [ZeroItemsScanner::class],
  fixers: [],
)]
class ZeroItemsScannerSolution extends SolutionBase {}
