<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api\Annotation;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Fixer annotation: Fixers act on problem items.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class Fixer extends Plugin {

  /**
   * Constructs a Fixer object.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $title
   *   A human-friendly name for this Fixer.
   * @param string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $title,
    public readonly ?string $deriver = NULL,
  ) {}

}
