<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api\Annotation;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Solution annotation: Solutions combine Scanners & Fixers to accomplish goals.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class Solution extends Plugin {

  /**
   * Constructs a Solution object.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $title
   *   A human-friendly name for this Solution.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   A longer description for this operation.
   * @param string[] $scanners
   *   A set of scanner IDs that make up this solution.
   * @param string[] $fixers
   *   A set of fixer IDs that make up this solution.
   * @param string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $title,
    public readonly ?TranslatableMarkup $description,
    public readonly array $scanners,
    public readonly array $fixers,
    public readonly ?string $deriver = NULL,
  ) {}

}
