<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api\Model;

/**
 * An interface to represent the result of running fixers over a set of items.
 */
interface SolutionResultsInterface {

  /**
   * Get the number of items that were not fully fixed.
   *
   * @return int
   *   The number of items that were not fully fixed.
   */
  public function getNumberOfFailures(): int;

  /**
   * Get the number of items that the fixer didn't think it could fix.
   *
   * @return int
   *   The number of items that the fixer didn't think it could fix.
   */
  public function getNumberOfSkipped(): int;

  /**
   * Get the number of items that were fully fixed.
   *
   * @return int
   *   The number of items that were fully fixed.
   */
  public function getNumberOfSuccesses(): int;

  /**
   * Get the total number of items that were tried.
   *
   * @return int
   *   The total number of items that were tried.
   */
  public function getNumberTried(): int;

  /**
   * Record that a fixer did not fully fix an item.
   */
  public function logFailure(): void;

  /**
   * Record that a fixer didn't think it could fix an item.
   */
  public function logSkipped(): void;

  /**
   * Record that a fixer fully fixed an item.
   */
  public function logSuccess(): void;

  /**
   * Get a string summarizing this results object.
   *
   * @return string|\Stringable
   *   A string summarizing this results object.
   */
  public function getSummaryString(): string|\Stringable;

}
