<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api\Solution;

use Drupal\scanner_fixer_api\Model\SolutionResultsInterface;

/**
 * Solution interface: Solutions combine Scanners & Fixers to accomplish goals.
 */
interface SolutionInterface {

  /**
   * Run the fixers defined for this solution on the given items.
   *
   * @param mixed[] $items
   *   An array of items to fix.
   *
   * @return \Drupal\scanner_fixer_api\Model\SolutionResultsInterface
   *   A data object representing the result of running a set of fixers over a
   *   set of items.
   */
  public function runFixers(array $items = []): SolutionResultsInterface;

  /**
   * Run the scanners defined for this solution.
   *
   * @return mixed[]
   *   An array of items to fix, found by the scanners.
   */
  public function runScanners(): array;

}
