<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api\Solution;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Adds permissions for each defined Scanner-Fixer Solution.
 */
class SolutionPermissions implements ContainerInjectionInterface {
  use StringTranslationTrait;

  /**
   * Plugin manager for solutions.
   *
   * @var \Drupal\scanner_fixer_api\Solution\SolutionPluginManager
   */
  protected SolutionPluginManager $solutionPluginManager;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = new self();
    $instance->solutionPluginManager = $container->get('plugin.manager.scanner_fixer_api.solution');
    return $instance;
  }

  /**
   * Adds permissions for each Scanner-Fixer Solution.
   *
   * @see scanner_fixer_api.permissions.yml
   * @see \Drupal\scanner_fixer_api\Form\SolutionWizard::access()
   */
  public function solutionsPermissions(): array {
    $permissions = [];

    $solutions = $this->solutionPluginManager->getDefinitions();
    foreach ($solutions as $solutionId => $solutionInfo) {
      $permissions["use solution $solutionId"] = [
        'title' => $this->t('Use @solution_label', [
          '@solution_label' => $solutionInfo['title'],
        ]),
        'description' => $solutionInfo['description'],
      ];
    }

    return $permissions;
  }

}
