<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api\Solution;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\scanner_fixer_api\Annotation\Solution;

/**
 * Plugin manager for solutions.
 */
class SolutionPluginManager extends DefaultPluginManager {

  /**
   * Constructs a SolutionPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   A cache backend for caching plugins of this type.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/ScannerFixer/Solution',
      $namespaces,
      $module_handler,
      SolutionInterface::class,
      Solution::class,
    );

    $this->alterInfo('scanner_fixer_solution_info');
    $this->setCacheBackend($cache_backend, 'scanner_fixer_solution_info_plugins');
  }

}
