<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Scanner;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Scanner;
use Drupal\scanner_fixer_api\Scanner\ScannerBase;

/**
 * A scanner that finds five items to fix.
 */
#[Scanner(
  id: "five_items_scanner",
  title: new TranslatableMarkup("Test: Five items scanner"),
)]
class FiveItemsScanner extends ScannerBase {

  /**
   * {@inheritdoc}
   */
  public function findProblemIds(): array {
    $ids = [];

    for ($i = 0; $i < 5; $i++) {
      $id = \mt_rand();
      $ids[$id] = $id;
    }

    return $ids;
  }

}
