<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Solution;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Solution;
use Drupal\scanner_fixer_api\Solution\SolutionBase;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Fixer\ExceptionFixer;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Scanner\OneItemsScanner;

/**
 * A test scanner-fixer that finds 1 item but throws exception when fixing it.
 */
#[Solution(
  id: "exception_fixer",
  title: new TranslatableMarkup("Test solution: Exception fixer"),
  description: new TranslatableMarkup("A scanner-fixer whose scanner finds one item and whose fixer throws an exception when trying to fix the item."),
  scanners: [OneItemsScanner::class],
  fixers: [ExceptionFixer::class],
)]
class ExceptionFixerSolution extends SolutionBase {}
