<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api\Scanner;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * A default, minimal implementation for a Scanner-Fixer Scanner.
 */
abstract class ScannerBase implements ScannerInterface, ContainerFactoryPluginInterface {

  /**
   * A configuration array containing information about the plugin instance.
   *
   * @var array
   */
  protected array $configuration;

  /**
   * The plugin implementation definition.
   *
   * @var mixed
   */
  protected mixed $pluginDefinition;

  /**
   * The plugin ID for the plugin instance.
   *
   * @var string
   */
  protected string $pluginId;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = new static();
    $instance->configuration = $configuration;
    $instance->pluginId = $plugin_id;
    $instance->pluginDefinition = $plugin_definition;
    return $instance;
  }

}
