<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Fixer;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Fixer;
use Drupal\scanner_fixer_api\Fixer\FixerBase;

/**
 * A fixer that says it can fix an item, but fails to fix it.
 */
#[Fixer(
  id: "capable_failure_fixer",
  title: new TranslatableMarkup("Test: capable, failure fixer"),
)]
class CapableFailureFixer extends FixerBase {

  /**
   * {@inheritdoc}
   */
  public function canFix(mixed $item): bool {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function performFix(mixed $item): bool {
    return FALSE;
  }

}
