<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Fixer;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Fixer;
use Drupal\scanner_fixer_api\Fixer\FixerBase;

/**
 * A fixer that says it cannot fix the item.
 */
#[Fixer(
  id: "incapable_fixer",
  title: new TranslatableMarkup("Test: incapable fixer"),
)]
class IncapableFixer extends FixerBase {

  /**
   * {@inheritdoc}
   */
  public function canFix(mixed $item): bool {
    return FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function performFix(mixed $item): bool {
    throw new \LogicException('This line of code should never be executed.');
  }

}
