<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Scanner;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Scanner;
use Drupal\scanner_fixer_api\Scanner\ScannerBase;

/**
 * A scanner that finds nothing to fix.
 */
#[Scanner(
  id: "zero_items_scanner",
  title: new TranslatableMarkup("Test: Zero items scanner"),
)]
class ZeroItemsScanner extends ScannerBase {

  /**
   * {@inheritdoc}
   */
  public function findProblemIds(): array {
    return [];
  }

}
