<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Solution;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Solution;
use Drupal\scanner_fixer_api\Solution\SolutionBase;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Fixer\CapableSuccessfulFixer;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Scanner\OneItemsScanner;

/**
 * A test scanner-fixer that finds 1 item and successfully fixes 1 item.
 */
#[Solution(
  id: "capable_successful_fixer",
  title: new TranslatableMarkup("Test solution: Capable, successful fixer"),
  description: new TranslatableMarkup("A scanner-fixer whose scanner finds one item and whose fixer says it can fix an item, then does so successfully."),
  scanners: [OneItemsScanner::class],
  fixers: [CapableSuccessfulFixer::class],
)]
class CapableSuccessfulFixerSolution extends SolutionBase {}
