<?php

declare(strict_types=1);

namespace Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Solution;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\scanner_fixer_api\Annotation\Solution;
use Drupal\scanner_fixer_api\Solution\SolutionBase;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Fixer\CapableSuccessfulFixer;
use Drupal\scanner_fixer_api_test\Plugin\ScannerFixer\Scanner\OneItemsScanner;

/**
 * A solution that uses more than one fixer to get its jobs done.
 */
#[Solution(
  id: "two_capable_successful_fixers",
  title: new TranslatableMarkup("Test solution: Two capable, successful fixers"),
  description: new TranslatableMarkup("A scanner-fixer that uses two instances of the capable, successful fixer."),
  scanners: [OneItemsScanner::class],
  fixers: [CapableSuccessfulFixer::class, CapableSuccessfulFixer::class],
)]
class TwoCapableSuccessfulFixersSolution extends SolutionBase {}
