<?php

declare(strict_types=1);

namespace Drupal\Tests\scanner_fixer_api\Functional;

use Drupal\Core\Url;
use Drupal\Tests\BrowserTestBase;

/**
 * Test users without permission to run a Solution cannot run that Solution.
 */
class SolutionWizardAccessDeniedTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['scanner_fixer_api_test'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Test users without permission to run a Solution cannot run that Solution.
   */
  public function testGetAccessDeniedWhenGivenPluginWithoutPermission(): void {
    // Setup: Create a user with permission to view the overview page and run
    // some other solution, but not the solution we try below.
    $this->drupalLogin($this->createUser([
      'use solution incapable_fixer',
      'use scanner-fixer solution overview page',
    ]));

    // SUT: Navigate to the wizard of a solution we don't have access to.
    $this->drupalGet(Url::fromRoute('scanner_fixer_api.solution.wizard', [
      'solutionId' => 'one_items_scanner',
    ]));

    // Asset: We get a 403.
    $this->assertSession()->statusCodeEquals(403);
  }

}
