<?php

declare(strict_types=1);

namespace Drupal\Tests\scanner_fixer_api\Functional;

use Drupal\Core\Url;
use Drupal\Tests\BrowserTestBase;

/**
 * Test we get error when we try to run a Solution wizard that does not exist.
 */
class SolutionWizardInvalidTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['scanner_fixer_api'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Test we get error when we try to run a Solution wizard that does not exist.
   */
  public function testNotFoundWhenGivenInvalidPluginId(): void {
    // Setup: Log in as an administrator that could, in theory, access all
    // solutions.
    $this->drupalLogin($this->createUser([], NULL, TRUE));

    // SUT: Navigate to the wizard of a solution we doesn't exist. Note that
    // this test installs scanner_fixer_api which doesn't define any solutions.
    $this->drupalGet(Url::fromRoute('scanner_fixer_api.solution.wizard', [
      'solutionId' => 'foo',
    ]));

    // Asset: We get a 404.
    $this->assertSession()->statusCodeEquals(404);
  }

}
