<?php

namespace Drupal\scheduler_field_item_published_notstatus\Entity;

use Drupal\Core\Entity\EntityPublishedInterface;
use Drupal\Core\Entity\EntityPublishedTrait;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\entity_test\Entity\EntityTest;

/**
 * Defines the test entity class.
 *
 * @ContentEntityType(
 *   id = "scheduler_field_test_pub_enabled",
 *   label = @Translation("Test entity"),
 *   handlers = {
 *     "list_builder" = "Drupal\scheduler_field_item_published_notstatus\EntityTestListBuilder",
 *     "view_builder" = "Drupal\scheduler_field_item_published_notstatus\EntityTestViewBuilder",
 *     "access" = "Drupal\scheduler_field_item_published_notstatus\EntityTestAccessControlHandler",
 *     "form" = {
 *       "default" = "Drupal\scheduler_field_item_published_notstatus\EntityTestForm",
 *       "delete" = "Drupal\scheduler_field_item_published_notstatus\EntityTestDeleteForm"
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\DefaultHtmlRouteProvider",
 *     },
 *     "views_data" = "Drupal\scheduler_field_item_published_notstatus\EntityTestViewsData"
 *   },
 *   base_table = "scheduler_field_test_pub_enabled",
 *   admin_permission = "administer scheduler_field_test_pub_enabled content",
 *   persistent_cache = FALSE,
 *   list_cache_contexts = { "scheduler_field_test_pub_enabled_view_grants" },
 *   entity_keys = {
 *     "id" = "id",
 *     "uuid" = "uuid",
 *     "bundle" = "type",
 *     "label" = "name",
 *     "langcode" = "langcode",
 *     "published" = "enabled",
 *   },
 *   links = {
 *     "canonical" = "/scheduler_field_test_pub_enabled/{scheduler_field_test_pub_enabled}",
 *     "add-form" = "/scheduler_field_test_pub_enabled/add",
 *     "edit-form" = "/scheduler_field_test_pub_enabled/manage/{scheduler_field_test_pub_enabled}/edit",
 *     "delete-form" = "/scheduler_field_test_pub_enabled/delete/scheduler_field_test_pub_enabled/{scheduler_field_test_pub_enabled}",
 *   },
 *   field_ui_base_route = "entity.scheduler_field_test_pub_enabled.admin_form",
 * )
 *
 * Note that this entity type annotation intentionally omits the "create" link
 * template. See https://www.drupal.org/node/2293697.
 */
class SchedulerFieldEntityTestPublishedEnabled extends EntityTest implements EntityPublishedInterface {

  use EntityPublishedTrait;

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {
    $fields = parent::baseFieldDefinitions($entity_type);

    // Add the publishing status field.
    $fields += static::publishedBaseFieldDefinitions($entity_type);

    return $fields;
  }

}
