<?php

namespace Drupal\schema_accommodation\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides a plugin for the 'occupancy' meta tag.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_accommodation_occupancy",
 *   label = @Translation("url"),
 *   description = @Translation("The allowed total occupancy."),
 *   name = "url",
 *   group = "schema_accommodation",
 *   weight = 0,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = FALSE,
 *   property_type = "quantitative_value",
 *   tree_parent = {},
 *   tree_depth = -1,
 * )
 */
class SchemaAccommodationOccupancy extends SchemaNameBase {

}
