<?php

namespace Drupal\schema_educational_occupational_credential\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides a plugin for the 'schema_educational_occupational_credential' meta tag.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_educational_occupational_credential_type",
 *   label = @Translation("@type"),
 *   description = @Translation("REQUIRED. The type of educational credential."),
 *   name = "@type",
 *   group = "schema_educational_occupational_credential",
 *   weight = -5,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = FALSE,
 *   property_type = "type",
 *   tree_parent = {
 *     "EducationalOccupationalCredential",
 *   },
 *   tree_depth = -1,
 * )
 */
class SchemaEducationalOccupationalCredentialType extends SchemaNameBase {

}
