<?php

namespace Drupal\schema_educational_occupational_credential\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides a plugin for the 'schema_educational_occupational_credential_valid_in' meta tag.
 *
 * @MetatagTag(
 *   id = "schema_educational_occupational_credential_valid_in",
 *   label = @Translation("validIn"),
 *   description = @Translation("The geographic area where a permit or similar thing is valid."),
 *   name = "validIn",
 *   group = "schema_educational_occupational_credential",
 *   weight = 5,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = TRUE,
 *   property_type = "place",
 *   tree_parent = {
 *     "Place",
 *     "Text",
 *   },
 *   tree_depth = 2,
 * )
 */
class SchemaEducationalOccupationalCredentialValidIn extends SchemaNameBase {
  // Inherits all functionality from SchemaNameBase.
}
