<?php

namespace Drupal\schema_form\Entity;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a listing of entities with ID, Label, Bundle columns.
 *
 * A copy of the Core's class from the issue
 * https://www.drupal.org/project/drupal/issues/2476669 until it is fixed in the
 * core.
 *
 * @see https://www.drupal.org/project/drupal/issues/2476669
 *
 * @todo Replace to the core class when the issue is fixed.
 */
class EntityLabelListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['id'] = $this->t('ID');
    if ($this->entityType->hasKey('label')) {
      $header['label'] = $this->t('Label');
    }
    if ($this->entityType->hasKey('bundle')) {
      $header['bundle'] = $this->t('Bundle');
    }

    return array_merge($header, parent::buildHeader());
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['id'] = $entity->id();
    if ($this->entityType->hasKey('label')) {
      $row['label'] = new Link($entity->label() ?? '[' . $entity->id() . ']', $entity->toUrl());
    }
    if ($this->entityType->hasKey('bundle')) {
      $row['bundle'] = $entity->bundle();
    }

    return array_merge($row, parent::buildRow($entity));
  }

}
