<?php

namespace Drupal\schema_form\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\Core\Entity\Attribute\ConfigEntityType;
use Drupal\Core\Entity\EntityDeleteForm;
use Drupal\Core\Entity\Routing\DefaultHtmlRouteProvider;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\schema_form\Form\SchemaFormEntityForm;

/**
 * Defines the Schema Form entity.
 */
#[ConfigEntityType(
  id: 'schema_form_design',
  label: new TranslatableMarkup('Schema Form Design'),
  label_collection: new TranslatableMarkup('Schema Form Designs'),
  label_singular: new TranslatableMarkup('Schema Form Design'),
  label_plural: new TranslatableMarkup('Schema Forms Designs'),
  config_prefix: 'design',

  handlers: [
    'list_builder' => EntityLabelListBuilder::class,
    'form' => [
      'add' => SchemaFormEntityForm::class,
      'edit' => SchemaFormEntityForm::class,
      'delete' => EntityDeleteForm::class,
    ],
    'route_provider' => [
      'default' => DefaultHtmlRouteProvider::class,
    ],
  ],
  admin_permission: 'administer site configuration',
  entity_keys: [
    'id' => 'id',
    'label' => 'label',
  ],
  links: [
    'collection' => '/admin/config/content/schema-form-design',
    'add-form' => '/admin/config/content/schema-form-design/add',
    'edit-form' => '/admin/config/content/schema-form-design/{schema_form_design}/edit',
    'delete-form' => '/admin/config/content/schema-form-design/{schema_form_design}/delete',
  ],
  config_export: [
    'id',
    'label',
    'schema',
    'design',
  ],
)]
class SchemaFormDesign extends ConfigEntityBase implements SchemaFormDesignInterface {
  /**
   * The ID.
   *
   * @var string
   */
  public $id;

  /**
   * The label.
   *
   * @var string
   */
  public $label;

  /**
   * The schema name.
   *
   * @var array
   */
  public $schema;

  /**
   * The form design data in YAML format.
   *
   * @var array
   */
  public $design;

}
