<?php

namespace Drupal\schema_form\Plugin\SchemaFormFieldType;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\schema_form\Attribute\SchemaFormFieldType;
use Drupal\schema_form\SchemaFormElementDto;

/**
 * Schema form field type implementation for checkboxes.
 */
#[SchemaFormFieldType(
  id: "checkbox",
  label: new TranslatableMarkup("Checkbox"),
  description: new TranslatableMarkup("A schema form field type for checkboxes."),
  types: [
    "boolean",
  ],
  weight: 0
)]
class Checkbox extends BaseSchemaFormFieldType {

  /**
   * {@inheritdoc}
   */
  public function buildTypedElement(SchemaFormElementDto $data): ?array {
    $element = [
      '#type' => 'checkbox',
    ];
    return $element;
  }

}
