<?php

namespace Drupal\schema_form\Plugin\SchemaFormFieldType;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\schema_form\Attribute\SchemaFormFieldType;
use Drupal\schema_form\SchemaFormElementDto;

/**
 * Schema form field type implementation for textareas.
 */
#[SchemaFormFieldType(
  id: "langcode",
  label: new TranslatableMarkup("Langcode"),
  description: new TranslatableMarkup("A schema form field type for langcode."),
  types: [
    "langcode",
  ],
  weight: 0
)]
class Langcode extends BaseSchemaFormFieldType {

  /**
   * {@inheritdoc}
   */
  public function buildTypedElement(SchemaFormElementDto $data): ?array {
    // Langcode is a special case, as it is not a standard field type and
    // should be handled automatically by the system.
    return NULL;
  }

}
