<?php

namespace Drupal\schema_form\Plugin\SchemaFormFieldType;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\schema_form\Attribute\SchemaFormFieldType;
use Drupal\schema_form\SchemaFormElementDto;

/**
 * Schema form field type implementation for mapping fields.
 */
#[SchemaFormFieldType(
  id: "mapping",
  label: new TranslatableMarkup("String"),
  description: new TranslatableMarkup("A schema form field type for strings."),
  types: [
    "mapping",
  ],
  weight: 0
)]
class Mapping extends BaseSchemaFormFieldType {

  /**
   * {@inheritdoc}
   */
  public function buildTypedElement(SchemaFormElementDto $data): ?array {
    $element = [
      '#type' => 'fieldset',
      '#tree' => TRUE,
    ];
    $element = $this->schemaForm->addChildrenElements($element, $data->definition['mapping']);
    return $element;
  }

}
