<?php

namespace Drupal\schema_form\Plugin\SchemaFormFieldType;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\schema_form\Attribute\SchemaFormFieldType;
use Drupal\schema_form\SchemaFormElementDto;

/**
 * Schema form field type implementation for numbers.
 */
#[SchemaFormFieldType(
  id: "number",
  label: new TranslatableMarkup("Number"),
  description: new TranslatableMarkup("A schema form field type for numbers."),
  types: [
    "integer",
    "float",
    "decimal",
  ],
  weight: 0
)]
class Number extends BaseSchemaFormFieldType {

  /**
   * {@inheritdoc}
   */
  public function buildTypedElement(SchemaFormElementDto $data): ?array {
    $element = [
      '#type' => 'number',
    ];
    if (
      in_array($data->definition['type'], [
        'float',
        'decimal',
      ])) {
      $element['#step'] = 'any';
    }
    return $element;
  }

}
