<?php

namespace Drupal\schema_form\Plugin\SchemaFormFieldType;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\schema_form\Attribute\SchemaFormFieldType;
use Drupal\schema_form\SchemaFormElementDto;

/**
 * Schema form field type implementation for textareas.
 */
#[SchemaFormFieldType(
  id: "sequence",
  label: new TranslatableMarkup("Sequence"),
  description: new TranslatableMarkup("A schema form field type for sequences (not implemented yet)."),
  types: [
    "sequence",
  ],
  weight: 0
)]
class Sequence extends BaseSchemaFormFieldType {

  /**
   * {@inheritdoc}
   */
  public function buildTypedElement(SchemaFormElementDto $data): ?array {
    $element = [
      // @todo Implement the sequence field type.
      '#type' => 'value',
    ];
    return $element;
  }

}
