<?php

namespace Drupal\schema_form\Plugin\SchemaFormFieldType;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\schema_form\Attribute\SchemaFormFieldType;
use Drupal\schema_form\SchemaFormElementDto;

/**
 * Schema form field type implementation for textareas.
 */
#[SchemaFormFieldType(
  id: "textarea",
  label: new TranslatableMarkup("Textarea"),
  description: new TranslatableMarkup("A schema form field type for textareas."),
  types: [
    "text",
  ],
  weight: 0
)]
class Textarea extends BaseSchemaFormFieldType {

  /**
   * {@inheritdoc}
   */
  public function buildTypedElement(SchemaFormElementDto $data): ?array {
    $element = [
      '#type' => 'textarea',
    ];
    return $element;
  }

}
