<?php

namespace Drupal\schema_form\Plugin\SchemaFormFieldType;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\schema_form\Attribute\SchemaFormFieldType;
use Drupal\schema_form\SchemaFormElementDto;

/**
 * Schema form field type implementation for textfields.
 *
 * This plugin handles the conversion of schema definitions with types 'string',
 * 'uri', 'email', 'uuid', 'label', and 'path' into appropriate Drupal form API
 * textfield elements. It automatically determines the appropriate HTML5 input
 * type based on the schema type.
 *
 * @see \Drupal\Core\Render\Element\Textfield
 */
#[SchemaFormFieldType(
  id: "textfield",
  label: new TranslatableMarkup("Textfield"),
  description: new TranslatableMarkup("A schema form field type for textfields."),
  types: [
    "string",
    "uri",
    "email",
    "uuid",
    "label",
    "path",
    // @todo Create a separate plugin for 'machine_name'.
    "machine_name",
    "required_label",
  ],
  weight: 0
)]
class Textfield extends BaseSchemaFormFieldType {

  /**
   * {@inheritdoc}
   */
  public function buildTypedElement(SchemaFormElementDto $data): ?array {
    $element = [];

    // Determine appropriate HTML5 input type based on schema type.
    switch ($data->definition['type']) {
      case 'uri':
        $element['#type'] = 'url';
        break;

      case 'email':
        $element['#type'] = 'email';
        break;

      default:
        $element['#type'] = 'textfield';
        break;
    }

    return $element;
  }

}
