<?php

namespace Drupal\schema_form\Plugin;

use Drupal\Component\Plugin\PluginManagerInterface;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\schema_form\Attribute\SchemaFormFieldType;

/**
 * Manages Schema Form Field Type plugins.
 */
class SchemaFormFieldTypeManager extends DefaultPluginManager implements PluginManagerInterface {

  /**
   * Constructs a SchemaFormFieldTypeManager object.
   *
   * @param \Traversable $namespaces
   *   An object that contains the root paths keyed by the corresponding
   *   namespace to look for plugin implementations.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   */
  public function __construct(\Traversable $namespaces, ModuleHandlerInterface $module_handler, CacheBackendInterface $cache_backend) {
    parent::__construct('Plugin/SchemaFormFieldType', $namespaces, $module_handler, NULL, SchemaFormFieldType::class);
    $this->alterInfo('schema_form_field_type_info');
    $this->setCacheBackend($cache_backend, 'schema_form_field_type_plugins');
  }

}
