<?php

declare(strict_types=1);

namespace Drupal\schema_form;

/**
 * Automatic form from the route options.
 *
 * This form class is used to automatically create a configuration form directly
 * from the route option 'editable_config_names', without a custom class.
 */
class SchemaConfigFromRouteForm extends SchemaConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getEditableConfigNames() {
    $routeOptions = $this->getRouteMatch()->getRouteObject()->getOptions();
    return $routeOptions['editable_config_names'] ?? NULL;
  }

}
