<?php

namespace Drupal\schema_form;

/**
 * Utility functions for the Schema Form.
 */
class SchemaFormUtils {

  /**
   * Prepares the textarea for saving in the config.
   *
   * @param array $element
   *   The form element.
   * @param string|null $input
   *   The input value.
   *
   * @return string
   *   The processed value.
   */
  public static function prepareTextareaForConfig(array $element, ?string $input = NULL): string {
    // A workaround to make the multiline textarea saved
    // as multiline string in the YAML config file.
    // @see https://www.drupal.org/project/drupal/issues/3244757
    if ($input !== NULL) {
      $value = preg_replace('/\r\n|\r/', "\n", $input);
      return $value;
    }
    // Return default value if no input.
    return $element['#default_value'] ?? '';
  }

}
