<?php

declare(strict_types=1);

namespace Drupal\schema_form_test\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\Core\Entity\Attribute\ConfigEntityType;
use Drupal\Core\Entity\EntityDeleteForm;
use Drupal\Core\Entity\Routing\DefaultHtmlRouteProvider;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\schema_form\Entity\EntityLabelListBuilder;
use Drupal\schema_form\Form\SchemaFormEntityForm;

/**
 * Defines the Schema Form Test Entity One entity.
 */
#[ConfigEntityType(
  id: 'schema_form_test_ent_one',
  label: new TranslatableMarkup('Schema Form Test Entity One'),
  config_prefix: 'my_module.conf_entity.schema_form_test_ent_one',

  handlers: [
    'list_builder' => EntityLabelListBuilder::class,
    'form' => [
      'add' => SchemaFormEntityForm::class,
      'edit' => SchemaFormEntityForm::class,
      'delete' => EntityDeleteForm::class,
    ],
    'route_provider' => [
      'default' => DefaultHtmlRouteProvider::class,
    ],
  ],
  admin_permission: 'administer site configuration',
  entity_keys: [
    'id' => 'id',
    'label' => 'field_string_three',
  ],
  links: [
    'collection' => '/admin/config/content/schema_form_test_ent_one',
    'add-form' => '/admin/config/content/schema_form_test_ent_one/add',
    'edit-form' => '/admin/config/content/schema_form_test_ent_one/{schema_form_test_ent_one}/edit',
    'delete-form' => '/admin/config/content/schema_form_test_ent_one/{schema_form_test_ent_one}/delete',
  ],
  config_export: [
    'id',
    'fieldOneInt',
    'fieldTwoString',
    'field_string_three',
  ],
)]
class SchemaFormTestEntityOne extends ConfigEntityBase {
  /**
   * Unique identifier for the Schema Form Test Entity One configuration entity.
   *
   * @var string
   */
  public $id;

  /**
   * An integer field for demonstration or testing purposes.
   *
   * @var int
   */
  public $fieldOneInt;

  /**
   * A string field representing the main label or name for the entity.
   *
   * @var string
   */
  public $fieldTwoString;

  /**
   * An additional string field for extended test data or metadata.
   *
   * @var string
   */
  public $field_string_three;

}
